//
// (c) 2020 wesolutions GmbH
// All rights reserved
//

import QtQuick 2.12

import wesual.Ui 1.0

import wesual.Ui.Private 1.0

UiButtonBase {
    id : uiButton

    implicitWidth  : 100
    implicitHeight : 100

    Rectangle {
        id : background

        anchors.fill : parent
        color : UiColors.getColor(UiColors.HoverGreen, 0)
    }

    states : [
        State {
            name : "pressed"
            when : uiButton.pressed || uiButton.down
            PropertyChanges {
                target : background
                color  : UiColors.getColor(
                             UiColors.SelectionGreen)
            }
        },
        State {
            name : "hovered"
            when : uiButton.hovered
            PropertyChanges {
                target : background
                color  : UiColors.getColor(UiColors.HoverGreen)
            }
        }
    ]
}
